<?php

#============================================================
# URL SHRTN             | URL shortening/forwarding script
#------------------------------------------------------------
# Script provided by Glype Media, http://www.glype.com/
#============================================================

# Run the pre-flight checks before attempting the install

# Start error reporting
error_reporting(E_ALL);
ini_set('display_errors',1);

# Define error function
function error($title,$msg) {
	include 'skin_top.php';
	echo '<h3>',$title,'</h3>',$msg;
	include 'skin_bottom.php';
	exit;
}

# Check our versions
if ( version_compare(PHP_VERSION,'5','<') ) {
	error('Incompatible PHP version','
	<p>URL Shrtn requires at least PHP version 5. You are running '.PHP_VERSION.'</p>
	<p>Please upgrade and rerun the installation.</p>');
}
if (! function_exists('mysql_get_client_info') || version_compare(mysql_get_client_info(),3,'<') ) {
	error('Incompatible MySQL version','
	<p>URL Shrtn requires at least MySQL version 3.0. You are running '.mysql_get_client_info().'</p>
	<p>Please upgrade and rerun the installation.</p>');
}

# Setup paths
define('PATH',dirname(dirname(__FILE__)));
define('S',DIRECTORY_SEPARATOR);

# Check permissions
$fileError = array();
if ( ! is_writable(PATH.S.'includes'.S.'config.php') )
	$fileError[] = '/includes/config.php';
if ( ! is_writable(PATH.S.'includes'.S.'banlist.php') )
	$fileError[] = '/includes/banlist.php';

# Show error
if ( ! empty($fileError) ) {
	$error = '<h3>Permission Denied. You must CHMOD the following files to 0777.</h3>';
	foreach ( $fileError as $err )
		$error .= '<p style="font-weight:bold;color:#ffc000; margin:2px 0 0 10px;">'.$err.'</p>';
	$error .= '<p>Please set these permissions in your FTP client and rerun this installation.</p>';
	error($error);
}

# Get our base URL
$URL = 'http'
				. ( empty($_SERVER['HTTPS']) ? '' : 's' )
				. '://'
				. $_SERVER['HTTP_HOST']
				. ( $_SERVER['SERVER_PORT'] != 80 ? ':' . $_SERVER['SERVER_PORT'] : '' )
				. preg_replace('@install/(.*)\.php@i','',$_SERVER['SCRIPT_NAME']);

# Clean function
function clean($val) {
	if ( get_magic_quotes_gpc() )
		$val = stripslashes($val);
	return trim($val);
}

?>